import numpy as np
import h5py
import matplotlib.pyplot as plt
plt.rcParams.update({'font.size': 17})
def r(f) :
    f=h5py.File(f)
    d = np.sum(np.array(f['dos']),axis=(0,1))
    w = np.array(f['omega'])
    d = d.real/np.sum(d[1:]*(w[1:]-w[:-1])) # normalized DOS to 1
    return w,d

w,d = r('extra/dos_qsgw.h5')
plt.plot(w,d,'k--',label='QSGW')

w,d = r('dos.h5')
plt.plot(w,d,'r-',label='QSGW+DMFT')

plt.ylim(0)
plt.xlabel(r'$\omega(eV)$')
plt.ylabel('DOS')
plt.legend()
plt.tight_layout()
plt.savefig('dos.png')
